package gov.va.genisis2.model;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 * The Class UserRoleType.
 * 
 * Description: In this UserRoleType Class implements the interface Serializable
 * and defines the entity and data mapping for the dbo.User_Role_Type Table in
 * the database.
 * 
 */
@Entity
@Table(name = "User_Role_Type", schema = "dbo")
public class UserRoleType implements java.io.Serializable {

	/** The Constant serialVersionUID. */
	private static final long serialVersionUID = 1129913211978526467L;

	/** The id. */
	private int id;
	
	/** The role type. */
	private RoleType roleType;
	
	/** The user. */
	private Users users;
	
	/** The user type. */
	private UserType userType;
	
	/** The start date. */
	private Date startDate;
	
	/** The end date. */
	private Date endDate;

	/**
	 * Instantiates a new user role type.
	 */
	public UserRoleType() {
		// Do nothing. The method is an intentionally-blank override.
	}

	/**
	 * Instantiates a new user role type.
	 *
	 * @param id the id
	 * @param roleType the role type
	 * @param users the users
	 * @param userType the user type
	 * @param startDate the start date
	 */
	public UserRoleType(int id, RoleType roleType, Users users, UserType userType, Date startDate) {
		this.id = id;
		this.roleType = roleType;
		this.users = users;
		this.userType = userType;
		this.startDate = startDate;
	}

	/**
	 * Instantiates a new user role type.
	 *
	 * @param id the id
	 * @param roleType the role type
	 * @param users the users
	 * @param userType the user type
	 * @param startDate the start date
	 * @param endDate the end date
	 */
	public UserRoleType(int id, RoleType roleType, Users users, UserType userType, Date startDate, Date endDate) {
		this.id = id;
		this.roleType = roleType;
		this.users = users;
		this.userType = userType;
		this.startDate = startDate;
		this.endDate = endDate;
	}

	/**
	 * Gets the id.
	 *
	 * @return the id
	 */
	@Id
	@Column(name = "Id", unique = true, nullable = false)
	public int getId() {
		return this.id;
	}

	/**
	 * Sets the id.
	 *
	 * @param id the new id
	 */
	public void setId(int id) {
		this.id = id;
	}

	/**
	 * Gets the role type.
	 *
	 * @return the role type
	 */
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name = "Role_Type_id", nullable = false)
	public RoleType getRoleType() {
		return this.roleType;
	}

	/**
	 * Sets the role type.
	 *
	 * @param roleType the new role type
	 */
	public void setRoleType(RoleType roleType) {
		this.roleType = roleType;
	}

	/**
	 * Gets the users.
	 *
	 * @return the users
	 */
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name = "User_id", nullable = false)
	public Users getUsers() {
		return this.users;
	}

	/**
	 * Sets the users.
	 *
	 * @param users the new users
	 */
	public void setUsers(Users users) {
		this.users = users;
	}

	/**
	 * Gets the user type.
	 *
	 * @return the user type
	 */
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name = "User_Type_id", nullable = false)
	public UserType getUserType() {
		return this.userType;
	}

	/**
	 * Sets the user type.
	 *
	 * @param userType the new user type
	 */
	public void setUserType(UserType userType) {
		this.userType = userType;
	}

	/**
	 * Gets the start date.
	 *
	 * @return the start date
	 */
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "Start_Date", nullable = false, length = 23)
	public Date getStartDate() {
		return this.startDate;
	}

	/**
	 * Sets the start date.
	 *
	 * @param startDate the new start date
	 */
	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	/**
	 * Gets the end date.
	 *
	 * @return the end date
	 */
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "End_Date", length = 23)
	public Date getEndDate() {
		return this.endDate;
	}

	/**
	 * Sets the end date.
	 *
	 * @param endDate the new end date
	 */
	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

}
